#ifndef GST_ImportShapefileMultilineString_h__
#define GST_ImportShapefileMultilineString_h__

#include "buildspec.h"

#include <string>
#include <vector>

#include <boost/ptr_container/ptr_vector.hpp>

#include <json_spirit/json_spirit.h>

namespace GST
{
namespace Parsers
{
class ShapeFileParser;
} // namespace Parsers
namespace Geometry
{
namespace GeoTagProfiles
{
struct ProfileInfo;
struct Linestring2d;
struct MultiLineString2d;
} // namespace GeoTagProfiles
class LinestringErrorChecks;

// TODO: docu
// TODO: better name
GST_API_EXPORT void importFromShapefile(
	std::vector<std::string> &multilineStrings,
	std::vector<std::string> &onames,
	std::string &srs,
	const Parsers::ShapeFileParser &parser,
	const std::string &onameColumnName,
	double verticalExaggeration);

GST_API_EXPORT void importFromShapefile(
	std::vector<std::string> &multilineStrings,
	std::vector<std::string> &onames,
	std::string &srs,
	const Parsers::ShapeFileParser &referenceLineParser,
	const Parsers::ShapeFileParser &profileLinesParser,
	const std::string &onameColumnName,
	const GeoTagProfiles::ProfileInfo &profileInfo);

GST_API_EXPORT void getAsMultiLinestring2ds(
	std::vector<GeoTagProfiles::MultiLineString2d> &multiLineStrings,
	std::vector<std::string> &titles,
	std::string &srs,
	const Parsers::ShapeFileParser &parser,
	const std::string &titleColumnName);

GST_API_EXPORT void getAsLinestring2ds(
	std::vector<GeoTagProfiles::Linestring2d> &lineStrings,
	std::vector<std::string> &titles,
	std::string &srs,
	json_spirit::Array &errors,
	const Parsers::ShapeFileParser &parser,
	const std::string &titleColumnName,
	const LinestringErrorChecks &errorChecks);

GST_API_EXPORT void getAsSfsLinestrings(
	std::vector<std::string> &lineStrings,
	std::vector<std::string> &titles,
	std::string &srs,
	std::vector<std::string> &errors,
	const Parsers::ShapeFileParser &parser,
	const std::string &titleColumnName,
	const LinestringErrorChecks &errorChecks);

} // namespace Geometry
} // namespace GST
#endif // GST_ImportShapefileMultilineString_h__
